/**
 * cbpFWTabs.js v1.0.0
 * http://www.codrops.com
 *
 * Licensed under the MIT license.
 * http://www.opensource.org/licenses/mit-license.php
 *
 * Copyright 2014, Codrops
 * http://www.codrops.com
 */
;( function( window ) {

	'use strict';

	function extend( a, b ) {
		for( var key in b ) {
			if( b.hasOwnProperty( key ) ) {
				a[key] = b[key];
			}
		}
		return a;
	}

	function CBPFWTabs( el, options ) {
		this.el = el;
		this.options = extend( {}, this.options );
  		extend( this.options, options );
  		this._init();
	}

	CBPFWTabs.prototype.options = {
		start : 0,
		wrapClass: 'tab-content-wrap',
		itemClass: 'tab-content-wrap__section',
		tabItemClass: 'tab-item'
	};

	CBPFWTabs.prototype._init = function() {
		// tabs elems
		this.tabs = [].slice.call( this.el.querySelectorAll( 'nav > ul > .'  + this.options.tabItemClass) );
		this.tabsOriginalClass = (this.tabs).map(function(elem) {
			return elem.getAttribute("class")
		});

		// content items
		var itemsCls = '.' + this.options.wrapClass + '> .' + this.options.itemClass;
		this.items = [].slice.call( this.el.querySelectorAll( itemsCls ) );
		// BTMANTIS0031740
		this.itemsOriginalClass = (this.items).map(function(elem) {
			return elem.getAttribute("class")
		});

		// current index
		this.current = -1;
		// show current content item
		this._show();
		// init events
		this._initEvents();
	};

	CBPFWTabs.prototype._initEvents = function() {
		var self = this;
		this.tabs.forEach( function( tab, idx ) {
			tab.addEventListener( 'click', function( ev ) {
				ev.preventDefault();
				self._show( idx );
			} );
		} );
	};

	CBPFWTabs.prototype._show = function( idx ) {
		if( this.current >= 0 ) {
			this.tabs[ this.current ].className = this.tabsOriginalClass[this.current];
			this.items[ this.current ].className = this.itemsOriginalClass[this.current];	// BTMANTIS0031740
		}
		// change current
		this.current = idx != undefined ? idx : this.options.start >= 0 && this.options.start < this.items.length ? this.options.start : 0;
		this.tabs[ this.current ].className = this.tabsOriginalClass[this.current] + ' tab-current';
		this.items[ this.current ].className = this.itemsOriginalClass[this.current] + ' content-current';	// BTMANTIS0031740
	};

	// add to global namespace
	window.CBPFWTabs = CBPFWTabs;

})( window );